/*------------------------------------------------------------------------------*
 * File Name: CategoricalDataEx.c												*
 * Creation: GJL 4/4/2005														*
 * Purpose: OriginC Source C file containing a CategoricalData example.			*
 * Copyright (c) OriginLab Corp.	2005, 2006, 2007, 2008, 2009, 2010			*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *------------------------------------------------------------------------------*/

#include <Origin.h>

// A worksheet with data values in column 1 must be active prior to execution
void CategoricalDataEx()
{
	Worksheet wks = Project.ActiveLayer();
	if( wks.IsValid() )
	{
		string str = wks.GetPage().GetName() + "_" + wks.Columns(0).GetName();
		CategoricalData cd(str);
		if( cd.IsValid() )
		{
			StringArray vCatMap;
			CategoricalMap cm;
			cm = cd.Map;
			if( cm )
			{
				printf("cd:\n\nData Value\tCategorical Data Value\n");
				printf("----------\t----------------------\n");
				for( int ii = 0; ii < cd.GetSize(); ii++ )
					printf("%s\t%d\n", cm[cd[ii]], cd[ii]);
			}
		}
	}
}
